// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import * as EventsAPI from "./events.mjs";
import { Events } from "./events.mjs";
import * as SnapshotsAPI from "./snapshots.mjs";
import { Snapshots, } from "./snapshots.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class Connectors extends APIResource {
    constructor() {
        super(...arguments);
        this.events = new EventsAPI.Events(this._client);
        this.snapshots = new SnapshotsAPI.Snapshots(this._client);
    }
    /**
     * Replace Connector
     */
    update(connectorId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/magic/connectors/${connectorId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List Connectors
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/magic/connectors`, ConnectorListResponsesSinglePage, options);
    }
    /**
     * Update Connector
     */
    edit(connectorId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/magic/connectors/${connectorId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetch Connector
     */
    get(connectorId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/magic/connectors/${connectorId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class ConnectorListResponsesSinglePage extends SinglePage {
}
Connectors.ConnectorListResponsesSinglePage = ConnectorListResponsesSinglePage;
Connectors.Events = Events;
Connectors.Snapshots = Snapshots;
//# sourceMappingURL=connectors.mjs.map