"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Events = void 0;
const resource_1 = require("../../../resource.js");
class Events extends resource_1.APIResource {
    /**
     * List Events
     */
    list(connectorId, params, options) {
        const { account_id, ...query } = params;
        return this._client.get(`/accounts/${account_id}/magic/connectors/${connectorId}/telemetry/events`, {
            query,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get Event
     */
    get(connectorId, eventT, eventN, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/magic/connectors/${connectorId}/telemetry/events/${eventT}.${eventN}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Events = Events;
//# sourceMappingURL=events.js.map