"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Snapshots = void 0;
const resource_1 = require("../../../resource.js");
class Snapshots extends resource_1.APIResource {
    /**
     * List Snapshots
     */
    list(connectorId, params, options) {
        const { account_id, ...query } = params;
        return this._client.get(`/accounts/${account_id}/magic/connectors/${connectorId}/telemetry/snapshots`, {
            query,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get Snapshot
     */
    get(connectorId, snapshotT, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/magic/connectors/${connectorId}/telemetry/snapshots/${snapshotT}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Snapshots = Snapshots;
//# sourceMappingURL=snapshots.js.map