// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
export class Snapshots extends APIResource {
    /**
     * List Snapshots
     */
    list(connectorId, params, options) {
        const { account_id, ...query } = params;
        return this._client.get(`/accounts/${account_id}/magic/connectors/${connectorId}/telemetry/snapshots`, {
            query,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get Snapshot
     */
    get(connectorId, snapshotT, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/magic/connectors/${connectorId}/telemetry/snapshots/${snapshotT}`, options)._thenUnwrap((obj) => obj.result);
    }
}
//# sourceMappingURL=snapshots.mjs.map