"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.GRETunnels = void 0;
const resource_1 = require("../../resource.js");
class GRETunnels extends resource_1.APIResource {
    /**
     * Creates new GRE tunnels. Use `?validate_only=true` as an optional query
     * parameter to only run validation without persisting changes.
     */
    create(params, options) {
        const { account_id, body, 'x-magic-new-hc-target': xMagicNewHcTarget } = params;
        return this._client.post(`/accounts/${account_id}/magic/gre_tunnels`, {
            body: body,
            ...options,
            headers: {
                ...(xMagicNewHcTarget?.toString() != null ?
                    { 'x-magic-new-hc-target': xMagicNewHcTarget?.toString() }
                    : undefined),
                ...options?.headers,
            },
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates a specific GRE tunnel. Use `?validate_only=true` as an optional query
     * parameter to only run validation without persisting changes.
     */
    update(greTunnelId, params, options) {
        const { account_id, 'x-magic-new-hc-target': xMagicNewHcTarget, ...body } = params;
        return this._client.put(`/accounts/${account_id}/magic/gre_tunnels/${greTunnelId}`, {
            body,
            ...options,
            headers: {
                ...(xMagicNewHcTarget?.toString() != null ?
                    { 'x-magic-new-hc-target': xMagicNewHcTarget?.toString() }
                    : undefined),
                ...options?.headers,
            },
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists GRE tunnels associated with an account.
     */
    list(params, options) {
        const { account_id, 'x-magic-new-hc-target': xMagicNewHcTarget } = params;
        return this._client.get(`/accounts/${account_id}/magic/gre_tunnels`, {
            ...options,
            headers: {
                ...(xMagicNewHcTarget?.toString() != null ?
                    { 'x-magic-new-hc-target': xMagicNewHcTarget?.toString() }
                    : undefined),
                ...options?.headers,
            },
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Disables and removes a specific static GRE tunnel. Use `?validate_only=true` as
     * an optional query parameter to only run validation without persisting changes.
     */
    delete(greTunnelId, params, options) {
        const { account_id, 'x-magic-new-hc-target': xMagicNewHcTarget } = params;
        return this._client.delete(`/accounts/${account_id}/magic/gre_tunnels/${greTunnelId}`, {
            ...options,
            headers: {
                ...(xMagicNewHcTarget?.toString() != null ?
                    { 'x-magic-new-hc-target': xMagicNewHcTarget?.toString() }
                    : undefined),
                ...options?.headers,
            },
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates multiple GRE tunnels. Use `?validate_only=true` as an optional query
     * parameter to only run validation without persisting changes.
     */
    bulkUpdate(params, options) {
        const { account_id, body, 'x-magic-new-hc-target': xMagicNewHcTarget } = params;
        return this._client.put(`/accounts/${account_id}/magic/gre_tunnels`, {
            body: body,
            ...options,
            headers: {
                ...(xMagicNewHcTarget?.toString() != null ?
                    { 'x-magic-new-hc-target': xMagicNewHcTarget?.toString() }
                    : undefined),
                ...options?.headers,
            },
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists informtion for a specific GRE tunnel.
     */
    get(greTunnelId, params, options) {
        const { account_id, 'x-magic-new-hc-target': xMagicNewHcTarget } = params;
        return this._client.get(`/accounts/${account_id}/magic/gre_tunnels/${greTunnelId}`, {
            ...options,
            headers: {
                ...(xMagicNewHcTarget?.toString() != null ?
                    { 'x-magic-new-hc-target': xMagicNewHcTarget?.toString() }
                    : undefined),
                ...options?.headers,
            },
        })._thenUnwrap((obj) => obj.result);
    }
}
exports.GRETunnels = GRETunnels;
//# sourceMappingURL=gre-tunnels.js.map