"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.IPSECTunnels = void 0;
const resource_1 = require("../../resource.js");
class IPSECTunnels extends resource_1.APIResource {
    /**
     * Creates new IPsec tunnels associated with an account. Use `?validate_only=true`
     * as an optional query parameter to only run validation without persisting
     * changes.
     */
    create(params, options) {
        const { account_id, 'x-magic-new-hc-target': xMagicNewHcTarget, ...body } = params;
        return this._client.post(`/accounts/${account_id}/magic/ipsec_tunnels`, {
            body,
            ...options,
            headers: {
                ...(xMagicNewHcTarget?.toString() != null ?
                    { 'x-magic-new-hc-target': xMagicNewHcTarget?.toString() }
                    : undefined),
                ...options?.headers,
            },
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates a specific IPsec tunnel associated with an account. Use
     * `?validate_only=true` as an optional query parameter to only run validation
     * without persisting changes.
     */
    update(ipsecTunnelId, params, options) {
        const { account_id, 'x-magic-new-hc-target': xMagicNewHcTarget, ...body } = params;
        return this._client.put(`/accounts/${account_id}/magic/ipsec_tunnels/${ipsecTunnelId}`, {
            body,
            ...options,
            headers: {
                ...(xMagicNewHcTarget?.toString() != null ?
                    { 'x-magic-new-hc-target': xMagicNewHcTarget?.toString() }
                    : undefined),
                ...options?.headers,
            },
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists IPsec tunnels associated with an account.
     */
    list(params, options) {
        const { account_id, 'x-magic-new-hc-target': xMagicNewHcTarget } = params;
        return this._client.get(`/accounts/${account_id}/magic/ipsec_tunnels`, {
            ...options,
            headers: {
                ...(xMagicNewHcTarget?.toString() != null ?
                    { 'x-magic-new-hc-target': xMagicNewHcTarget?.toString() }
                    : undefined),
                ...options?.headers,
            },
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Disables and removes a specific static IPsec Tunnel associated with an account.
     * Use `?validate_only=true` as an optional query parameter to only run validation
     * without persisting changes.
     */
    delete(ipsecTunnelId, params, options) {
        const { account_id, 'x-magic-new-hc-target': xMagicNewHcTarget } = params;
        return this._client.delete(`/accounts/${account_id}/magic/ipsec_tunnels/${ipsecTunnelId}`, {
            ...options,
            headers: {
                ...(xMagicNewHcTarget?.toString() != null ?
                    { 'x-magic-new-hc-target': xMagicNewHcTarget?.toString() }
                    : undefined),
                ...options?.headers,
            },
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update multiple IPsec tunnels associated with an account. Use
     * `?validate_only=true` as an optional query parameter to only run validation
     * without persisting changes.
     */
    bulkUpdate(params, options) {
        const { account_id, body, 'x-magic-new-hc-target': xMagicNewHcTarget } = params;
        return this._client.put(`/accounts/${account_id}/magic/ipsec_tunnels`, {
            body: body,
            ...options,
            headers: {
                ...(xMagicNewHcTarget?.toString() != null ?
                    { 'x-magic-new-hc-target': xMagicNewHcTarget?.toString() }
                    : undefined),
                ...options?.headers,
            },
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists details for a specific IPsec tunnel.
     */
    get(ipsecTunnelId, params, options) {
        const { account_id, 'x-magic-new-hc-target': xMagicNewHcTarget } = params;
        return this._client.get(`/accounts/${account_id}/magic/ipsec_tunnels/${ipsecTunnelId}`, {
            ...options,
            headers: {
                ...(xMagicNewHcTarget?.toString() != null ?
                    { 'x-magic-new-hc-target': xMagicNewHcTarget?.toString() }
                    : undefined),
                ...options?.headers,
            },
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Generates a Pre Shared Key for a specific IPsec tunnel used in the IKE session.
     * Use `?validate_only=true` as an optional query parameter to only run validation
     * without persisting changes. After a PSK is generated, the PSK is immediately
     * persisted to Cloudflare's edge and cannot be retrieved later. Note the PSK in a
     * safe place.
     */
    pskGenerate(ipsecTunnelId, params, options) {
        const { account_id, body } = params;
        return this._client.post(`/accounts/${account_id}/magic/ipsec_tunnels/${ipsecTunnelId}/psk_generate`, {
            body: body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
}
exports.IPSECTunnels = IPSECTunnels;
//# sourceMappingURL=ipsec-tunnels.js.map