// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import * as AppsAPI from "./apps.mjs";
import { AppListResponsesSinglePage, Apps, } from "./apps.mjs";
import * as CfInterconnectsAPI from "./cf-interconnects.mjs";
import { CfInterconnects, } from "./cf-interconnects.mjs";
import * as GRETunnelsAPI from "./gre-tunnels.mjs";
import { GRETunnels, } from "./gre-tunnels.mjs";
import * as IPSECTunnelsAPI from "./ipsec-tunnels.mjs";
import { IPSECTunnels, } from "./ipsec-tunnels.mjs";
import * as RoutesAPI from "./routes.mjs";
import { Routes, } from "./routes.mjs";
import * as ConnectorsAPI from "./connectors/connectors.mjs";
import { ConnectorListResponsesSinglePage, Connectors, } from "./connectors/connectors.mjs";
import * as PCAPsAPI from "./pcaps/pcaps.mjs";
import { PCAPListResponsesSinglePage, PCAPs, } from "./pcaps/pcaps.mjs";
import * as SitesAPI from "./sites/sites.mjs";
import { Sites, SitesSinglePage, } from "./sites/sites.mjs";
export class MagicTransit extends APIResource {
    constructor() {
        super(...arguments);
        this.apps = new AppsAPI.Apps(this._client);
        this.cfInterconnects = new CfInterconnectsAPI.CfInterconnects(this._client);
        this.greTunnels = new GRETunnelsAPI.GRETunnels(this._client);
        this.ipsecTunnels = new IPSECTunnelsAPI.IPSECTunnels(this._client);
        this.routes = new RoutesAPI.Routes(this._client);
        this.sites = new SitesAPI.Sites(this._client);
        this.connectors = new ConnectorsAPI.Connectors(this._client);
        this.pcaps = new PCAPsAPI.PCAPs(this._client);
    }
}
MagicTransit.Apps = Apps;
MagicTransit.AppListResponsesSinglePage = AppListResponsesSinglePage;
MagicTransit.CfInterconnects = CfInterconnects;
MagicTransit.GRETunnels = GRETunnels;
MagicTransit.IPSECTunnels = IPSECTunnels;
MagicTransit.Routes = Routes;
MagicTransit.Sites = Sites;
MagicTransit.SitesSinglePage = SitesSinglePage;
MagicTransit.Connectors = Connectors;
MagicTransit.ConnectorListResponsesSinglePage = ConnectorListResponsesSinglePage;
MagicTransit.PCAPs = PCAPs;
MagicTransit.PCAPListResponsesSinglePage = PCAPListResponsesSinglePage;
//# sourceMappingURL=magic-transit.mjs.map