"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Download = void 0;
const resource_1 = require("../../../resource.js");
class Download extends resource_1.APIResource {
    /**
     * Download PCAP information into a file. Response is a binary PCAP file.
     */
    get(pcapId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/pcaps/${pcapId}/download`, {
            ...options,
            headers: { Accept: 'application/vnd.tcpdump.pcap', ...options?.headers },
            __binaryResponse: true,
        });
    }
}
exports.Download = Download;
//# sourceMappingURL=download.js.map