"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.OwnershipsSinglePage = exports.OwnershipResource = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class OwnershipResource extends resource_1.APIResource {
    /**
     * Adds an AWS or GCP bucket to use with full packet captures.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/pcaps/ownership`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Deletes buckets added to the packet captures API.
     */
    delete(ownershipId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/pcaps/ownership/${ownershipId}`, {
            ...options,
            headers: { Accept: '*/*', ...options?.headers },
        });
    }
    /**
     * List all buckets configured for use with PCAPs API.
     */
    get(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/pcaps/ownership`, OwnershipsSinglePage, options);
    }
    /**
     * Validates buckets added to the packet captures API.
     */
    validate(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/pcaps/ownership/validate`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
}
exports.OwnershipResource = OwnershipResource;
class OwnershipsSinglePage extends pagination_1.SinglePage {
}
exports.OwnershipsSinglePage = OwnershipsSinglePage;
OwnershipResource.OwnershipsSinglePage = OwnershipsSinglePage;
//# sourceMappingURL=ownership.js.map