// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class OwnershipResource extends APIResource {
    /**
     * Adds an AWS or GCP bucket to use with full packet captures.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/pcaps/ownership`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Deletes buckets added to the packet captures API.
     */
    delete(ownershipId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/pcaps/ownership/${ownershipId}`, {
            ...options,
            headers: { Accept: '*/*', ...options?.headers },
        });
    }
    /**
     * List all buckets configured for use with PCAPs API.
     */
    get(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/pcaps/ownership`, OwnershipsSinglePage, options);
    }
    /**
     * Validates buckets added to the packet captures API.
     */
    validate(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/pcaps/ownership/validate`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
}
export class OwnershipsSinglePage extends SinglePage {
}
OwnershipResource.OwnershipsSinglePage = OwnershipsSinglePage;
//# sourceMappingURL=ownership.mjs.map