// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import * as DownloadAPI from "./download.mjs";
import { Download } from "./download.mjs";
import * as OwnershipAPI from "./ownership.mjs";
import { OwnershipResource, OwnershipsSinglePage, } from "./ownership.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class PCAPs extends APIResource {
    constructor() {
        super(...arguments);
        this.ownership = new OwnershipAPI.OwnershipResource(this._client);
        this.download = new DownloadAPI.Download(this._client);
    }
    /**
     * Create new PCAP request for account.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/pcaps`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists all packet capture requests for an account.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/pcaps`, PCAPListResponsesSinglePage, options);
    }
    /**
     * Get information for a PCAP request by id.
     */
    get(pcapId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/pcaps/${pcapId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class PCAPListResponsesSinglePage extends SinglePage {
}
PCAPs.PCAPListResponsesSinglePage = PCAPListResponsesSinglePage;
PCAPs.OwnershipResource = OwnershipResource;
PCAPs.OwnershipsSinglePage = OwnershipsSinglePage;
PCAPs.Download = Download;
//# sourceMappingURL=pcaps.mjs.map