"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Routes = void 0;
const resource_1 = require("../../resource.js");
class Routes extends resource_1.APIResource {
    /**
     * Creates a new Magic static route. Use `?validate_only=true` as an optional query
     * parameter to run validation only without persisting changes.
     */
    create(params, options) {
        const { account_id, body } = params;
        return this._client.post(`/accounts/${account_id}/magic/routes`, {
            body: body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update a specific Magic static route. Use `?validate_only=true` as an optional
     * query parameter to run validation only without persisting changes.
     */
    update(routeId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/magic/routes/${routeId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List all Magic static routes.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/magic/routes`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Disable and remove a specific Magic static route.
     */
    delete(routeId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/magic/routes/${routeId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update multiple Magic static routes. Use `?validate_only=true` as an optional
     * query parameter to run validation only without persisting changes. Only fields
     * for a route that need to be changed need be provided.
     */
    bulkUpdate(params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/magic/routes`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Delete multiple Magic static routes.
     */
    empty(params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/magic/routes`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get a specific Magic static route.
     */
    get(routeId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/magic/routes/${routeId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Routes = Routes;
//# sourceMappingURL=routes.js.map