// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class ACLs extends APIResource {
    /**
     * Creates a new Site ACL.
     */
    create(siteId, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/magic/sites/${siteId}/acls`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update a specific Site ACL.
     */
    update(siteId, aclId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/magic/sites/${siteId}/acls/${aclId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists Site ACLs associated with an account.
     */
    list(siteId, params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/magic/sites/${siteId}/acls`, ACLsSinglePage, options);
    }
    /**
     * Remove a specific Site ACL.
     */
    delete(siteId, aclId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/magic/sites/${siteId}/acls/${aclId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Patch a specific Site ACL.
     */
    edit(siteId, aclId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/magic/sites/${siteId}/acls/${aclId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get a specific Site ACL.
     */
    get(siteId, aclId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/magic/sites/${siteId}/acls/${aclId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class ACLsSinglePage extends SinglePage {
}
ACLs.ACLsSinglePage = ACLsSinglePage;
//# sourceMappingURL=acls.mjs.map