// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class LANs extends APIResource {
    /**
     * Creates a new Site LAN. If the site is in high availability mode,
     * static_addressing is required along with secondary and virtual address.
     */
    create(siteId, params, options) {
        const { account_id, ...body } = params;
        return this._client.getAPIList(`/accounts/${account_id}/magic/sites/${siteId}/lans`, LANsSinglePage, {
            body,
            method: 'post',
            ...options,
        });
    }
    /**
     * Update a specific Site LAN.
     */
    update(siteId, lanId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/magic/sites/${siteId}/lans/${lanId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists Site LANs associated with an account.
     */
    list(siteId, params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/magic/sites/${siteId}/lans`, LANsSinglePage, options);
    }
    /**
     * Remove a specific Site LAN.
     */
    delete(siteId, lanId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/magic/sites/${siteId}/lans/${lanId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Patch a specific Site LAN.
     */
    edit(siteId, lanId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/magic/sites/${siteId}/lans/${lanId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get a specific Site LAN.
     */
    get(siteId, lanId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/magic/sites/${siteId}/lans/${lanId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class LANsSinglePage extends SinglePage {
}
LANs.LANsSinglePage = LANsSinglePage;
//# sourceMappingURL=lans.mjs.map