"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.WANsSinglePage = exports.WANs = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class WANs extends resource_1.APIResource {
    /**
     * Creates a new Site WAN.
     */
    create(siteId, params, options) {
        const { account_id, ...body } = params;
        return this._client.getAPIList(`/accounts/${account_id}/magic/sites/${siteId}/wans`, WANsSinglePage, {
            body,
            method: 'post',
            ...options,
        });
    }
    /**
     * Update a specific Site WAN.
     */
    update(siteId, wanId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/magic/sites/${siteId}/wans/${wanId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists Site WANs associated with an account.
     */
    list(siteId, params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/magic/sites/${siteId}/wans`, WANsSinglePage, options);
    }
    /**
     * Remove a specific Site WAN.
     */
    delete(siteId, wanId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/magic/sites/${siteId}/wans/${wanId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Patch a specific Site WAN.
     */
    edit(siteId, wanId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/magic/sites/${siteId}/wans/${wanId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get a specific Site WAN.
     */
    get(siteId, wanId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/magic/sites/${siteId}/wans/${wanId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.WANs = WANs;
class WANsSinglePage extends pagination_1.SinglePage {
}
exports.WANsSinglePage = WANsSinglePage;
WANs.WANsSinglePage = WANsSinglePage;
//# sourceMappingURL=wans.js.map