// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class WANs extends APIResource {
    /**
     * Creates a new Site WAN.
     */
    create(siteId, params, options) {
        const { account_id, ...body } = params;
        return this._client.getAPIList(`/accounts/${account_id}/magic/sites/${siteId}/wans`, WANsSinglePage, {
            body,
            method: 'post',
            ...options,
        });
    }
    /**
     * Update a specific Site WAN.
     */
    update(siteId, wanId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/magic/sites/${siteId}/wans/${wanId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists Site WANs associated with an account.
     */
    list(siteId, params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/magic/sites/${siteId}/wans`, WANsSinglePage, options);
    }
    /**
     * Remove a specific Site WAN.
     */
    delete(siteId, wanId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/magic/sites/${siteId}/wans/${wanId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Patch a specific Site WAN.
     */
    edit(siteId, wanId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/magic/sites/${siteId}/wans/${wanId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get a specific Site WAN.
     */
    get(siteId, wanId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/magic/sites/${siteId}/wans/${wanId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class WANsSinglePage extends SinglePage {
}
WANs.WANsSinglePage = WANsSinglePage;
//# sourceMappingURL=wans.mjs.map