import { APIResource } from "../../resource.js";
import * as Core from "../../core.js";
import * as AssociationsAPI from "./associations.js";
import { AssociationGetParams, Associations, CertificateAsssociation, CertificateAsssociationsSinglePage } from "./associations.js";
import { SinglePage } from "../../pagination.js";
export declare class MTLSCertificates extends APIResource {
    associations: AssociationsAPI.Associations;
    /**
     * Upload a certificate that you want to use with mTLS-enabled Cloudflare services.
     */
    create(params: MTLSCertificateCreateParams, options?: Core.RequestOptions): Core.APIPromise<MTLSCertificateCreateResponse>;
    /**
     * Lists all mTLS certificates.
     */
    list(params: MTLSCertificateListParams, options?: Core.RequestOptions): Core.PagePromise<MTLSCertificatesSinglePage, MTLSCertificate>;
    /**
     * Deletes the mTLS certificate unless the certificate is in use by one or more
     * Cloudflare services.
     */
    delete(mtlsCertificateId: string, params: MTLSCertificateDeleteParams, options?: Core.RequestOptions): Core.APIPromise<MTLSCertificate>;
    /**
     * Fetches a single mTLS certificate.
     */
    get(mtlsCertificateId: string, params: MTLSCertificateGetParams, options?: Core.RequestOptions): Core.APIPromise<MTLSCertificate>;
}
export declare class MTLSCertificatesSinglePage extends SinglePage<MTLSCertificate> {
}
export interface MTLSCertificate {
    /**
     * Identifier
     */
    id?: string;
    /**
     * Indicates whether the certificate is a CA or leaf certificate.
     */
    ca?: boolean;
    /**
     * The uploaded root CA certificate.
     */
    certificates?: string;
    /**
     * When the certificate expires.
     */
    expires_on?: string;
    /**
     * The certificate authority that issued the certificate.
     */
    issuer?: string;
    /**
     * Optional unique name for the certificate. Only used for human readability.
     */
    name?: string;
    /**
     * The certificate serial number.
     */
    serial_number?: string;
    /**
     * The type of hash used for the certificate.
     */
    signature?: string;
    /**
     * This is the time the certificate was uploaded.
     */
    uploaded_on?: string;
}
export interface MTLSCertificateCreateResponse {
    /**
     * Identifier
     */
    id?: string;
    /**
     * Indicates whether the certificate is a CA or leaf certificate.
     */
    ca?: boolean;
    /**
     * The uploaded root CA certificate.
     */
    certificates?: string;
    /**
     * When the certificate expires.
     */
    expires_on?: string;
    /**
     * The certificate authority that issued the certificate.
     */
    issuer?: string;
    /**
     * Optional unique name for the certificate. Only used for human readability.
     */
    name?: string;
    /**
     * The certificate serial number.
     */
    serial_number?: string;
    /**
     * The type of hash used for the certificate.
     */
    signature?: string;
    /**
     * This is the time the certificate was updated.
     */
    updated_at?: string;
    /**
     * This is the time the certificate was uploaded.
     */
    uploaded_on?: string;
}
export interface MTLSCertificateCreateParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Body param: Indicates whether the certificate is a CA or leaf certificate.
     */
    ca: boolean;
    /**
     * Body param: The uploaded root CA certificate.
     */
    certificates: string;
    /**
     * Body param: Optional unique name for the certificate. Only used for human
     * readability.
     */
    name?: string;
    /**
     * Body param: The private key for the certificate
     */
    private_key?: string;
}
export interface MTLSCertificateListParams {
    /**
     * Identifier
     */
    account_id: string;
}
export interface MTLSCertificateDeleteParams {
    /**
     * Identifier
     */
    account_id: string;
}
export interface MTLSCertificateGetParams {
    /**
     * Identifier
     */
    account_id: string;
}
export declare namespace MTLSCertificates {
    export { Associations as Associations, type CertificateAsssociation as CertificateAsssociation, CertificateAsssociationsSinglePage as CertificateAsssociationsSinglePage, type AssociationGetParams as AssociationGetParams, };
}
//# sourceMappingURL=mtls-certificates.d.ts.map