"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MTLSCertificatesSinglePage = exports.MTLSCertificates = void 0;
const resource_1 = require("../../resource.js");
const AssociationsAPI = __importStar(require("./associations.js"));
const associations_1 = require("./associations.js");
const pagination_1 = require("../../pagination.js");
class MTLSCertificates extends resource_1.APIResource {
    constructor() {
        super(...arguments);
        this.associations = new AssociationsAPI.Associations(this._client);
    }
    /**
     * Upload a certificate that you want to use with mTLS-enabled Cloudflare services.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/mtls_certificates`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists all mTLS certificates.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/mtls_certificates`, MTLSCertificatesSinglePage, options);
    }
    /**
     * Deletes the mTLS certificate unless the certificate is in use by one or more
     * Cloudflare services.
     */
    delete(mtlsCertificateId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/mtls_certificates/${mtlsCertificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches a single mTLS certificate.
     */
    get(mtlsCertificateId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/mtls_certificates/${mtlsCertificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.MTLSCertificates = MTLSCertificates;
class MTLSCertificatesSinglePage extends pagination_1.SinglePage {
}
exports.MTLSCertificatesSinglePage = MTLSCertificatesSinglePage;
MTLSCertificates.Associations = associations_1.Associations;
MTLSCertificates.CertificateAsssociationsSinglePage = associations_1.CertificateAsssociationsSinglePage;
//# sourceMappingURL=mtls-certificates.js.map