// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import * as AssociationsAPI from "./associations.mjs";
import { Associations, CertificateAsssociationsSinglePage, } from "./associations.mjs";
import { SinglePage } from "../../pagination.mjs";
export class MTLSCertificates extends APIResource {
    constructor() {
        super(...arguments);
        this.associations = new AssociationsAPI.Associations(this._client);
    }
    /**
     * Upload a certificate that you want to use with mTLS-enabled Cloudflare services.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/mtls_certificates`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists all mTLS certificates.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/mtls_certificates`, MTLSCertificatesSinglePage, options);
    }
    /**
     * Deletes the mTLS certificate unless the certificate is in use by one or more
     * Cloudflare services.
     */
    delete(mtlsCertificateId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/mtls_certificates/${mtlsCertificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches a single mTLS certificate.
     */
    get(mtlsCertificateId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/mtls_certificates/${mtlsCertificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class MTLSCertificatesSinglePage extends SinglePage {
}
MTLSCertificates.Associations = Associations;
MTLSCertificates.CertificateAsssociationsSinglePage = CertificateAsssociationsSinglePage;
//# sourceMappingURL=mtls-certificates.mjs.map