// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
export class CNIs extends APIResource {
    /**
     * Create a new CNI object
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/cni/cnis`, { body, ...options });
    }
    /**
     * Modify stored information about a CNI object
     */
    update(cni, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/cni/cnis/${cni}`, { body, ...options });
    }
    /**
     * List existing CNI objects
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.get(`/accounts/${account_id}/cni/cnis`, { query, ...options });
    }
    /**
     * Delete a specified CNI object
     */
    delete(cni, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/cni/cnis/${cni}`, {
            ...options,
            headers: { Accept: '*/*', ...options?.headers },
        });
    }
    /**
     * Get information about a CNI object
     */
    get(cni, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/cni/cnis/${cni}`, options);
    }
}
//# sourceMappingURL=cnis.mjs.map