"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Interconnects = void 0;
const resource_1 = require("../../resource.js");
class Interconnects extends resource_1.APIResource {
    /**
     * Create a new interconnect
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/cni/interconnects`, { body, ...options });
    }
    /**
     * List existing interconnects
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.get(`/accounts/${account_id}/cni/interconnects`, { query, ...options });
    }
    /**
     * Delete an interconnect object
     */
    delete(icon, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/cni/interconnects/${icon}`, {
            ...options,
            headers: { Accept: '*/*', ...options?.headers },
        });
    }
    /**
     * Get information about an interconnect object
     */
    get(icon, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/cni/interconnects/${icon}`, options);
    }
    /**
     * Generate the Letter of Authorization (LOA) for a given interconnect
     */
    loa(icon, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/cni/interconnects/${icon}/loa`, {
            ...options,
            headers: { Accept: '*/*', ...options?.headers },
        });
    }
    /**
     * Get the current status of an interconnect object
     */
    status(icon, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/cni/interconnects/${icon}/status`, options);
    }
}
exports.Interconnects = Interconnects;
//# sourceMappingURL=interconnects.js.map