import { APIResource } from "../../resource.js";
import * as Core from "../../core.js";
export declare class Slots extends APIResource {
    /**
     * Retrieve a list of all slots matching the specified parameters
     */
    list(params: SlotListParams, options?: Core.RequestOptions): Core.APIPromise<SlotListResponse>;
    /**
     * Get information about the specified slot
     */
    get(slot: string, params: SlotGetParams, options?: Core.RequestOptions): Core.APIPromise<SlotGetResponse>;
}
export interface SlotListResponse {
    items: Array<SlotListResponse.Item>;
    next?: number | null;
}
export declare namespace SlotListResponse {
    interface Item {
        /**
         * Slot ID
         */
        id: string;
        facility: Item.Facility;
        /**
         * Whether the slot is occupied or not
         */
        occupied: boolean;
        site: string;
        speed: string;
        /**
         * Customer account tag
         */
        account?: string;
    }
    namespace Item {
        interface Facility {
            address: Array<string>;
            name: string;
        }
    }
}
export interface SlotGetResponse {
    /**
     * Slot ID
     */
    id: string;
    facility: SlotGetResponse.Facility;
    /**
     * Whether the slot is occupied or not
     */
    occupied: boolean;
    site: string;
    speed: string;
    /**
     * Customer account tag
     */
    account?: string;
}
export declare namespace SlotGetResponse {
    interface Facility {
        address: Array<string>;
        name: string;
    }
}
export interface SlotListParams {
    /**
     * Path param: Customer account tag
     */
    account_id: string;
    /**
     * Query param: If specified, only show slots with the given text in their address
     * field
     */
    address_contains?: string | null;
    /**
     * Query param:
     */
    cursor?: number | null;
    /**
     * Query param:
     */
    limit?: number | null;
    /**
     * Query param: If specified, only show slots with a specific occupied/unoccupied
     * state
     */
    occupied?: boolean | null;
    /**
     * Query param: If specified, only show slots located at the given site
     */
    site?: string | null;
    /**
     * Query param: If specified, only show slots that support the given speed
     */
    speed?: string | null;
}
export interface SlotGetParams {
    /**
     * Customer account tag
     */
    account_id: string;
}
export declare namespace Slots {
    export { type SlotListResponse as SlotListResponse, type SlotGetResponse as SlotGetResponse, type SlotListParams as SlotListParams, type SlotGetParams as SlotGetParams, };
}
//# sourceMappingURL=slots.d.ts.map