"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Slots = void 0;
const resource_1 = require("../../resource.js");
class Slots extends resource_1.APIResource {
    /**
     * Retrieve a list of all slots matching the specified parameters
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.get(`/accounts/${account_id}/cni/slots`, { query, ...options });
    }
    /**
     * Get information about the specified slot
     */
    get(slot, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/cni/slots/${slot}`, options);
    }
}
exports.Slots = Slots;
//# sourceMappingURL=slots.js.map