// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
export class Slots extends APIResource {
    /**
     * Retrieve a list of all slots matching the specified parameters
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.get(`/accounts/${account_id}/cni/slots`, { query, ...options });
    }
    /**
     * Get information about the specified slot
     */
    get(slot, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/cni/slots/${slot}`, options);
    }
}
//# sourceMappingURL=slots.mjs.map