import { APIResource } from "../resource.js";
import * as Core from "../core.js";
import * as Shared from "./shared.js";
import * as CertificatePacksAPI from "./ssl/certificate-packs/certificate-packs.js";
import { SinglePage } from "../pagination.js";
export declare class OriginCACertificates extends APIResource {
    /**
     * Create an Origin CA certificate. You can use an Origin CA Key as your User
     * Service Key or an API token when calling this endpoint ([see above](#requests)).
     */
    create(body: OriginCACertificateCreateParams, options?: Core.RequestOptions): Core.APIPromise<OriginCACertificate>;
    /**
     * List all existing Origin CA certificates for a given zone. You can use an Origin
     * CA Key as your User Service Key or an API token when calling this endpoint
     * ([see above](#requests)).
     */
    list(query: OriginCACertificateListParams, options?: Core.RequestOptions): Core.PagePromise<OriginCACertificatesSinglePage, OriginCACertificate>;
    /**
     * Revoke an existing Origin CA certificate by its serial number. You can use an
     * Origin CA Key as your User Service Key or an API token when calling this
     * endpoint ([see above](#requests)).
     */
    delete(certificateId: string, options?: Core.RequestOptions): Core.APIPromise<OriginCACertificateDeleteResponse>;
    /**
     * Get an existing Origin CA certificate by its serial number. You can use an
     * Origin CA Key as your User Service Key or an API token when calling this
     * endpoint ([see above](#requests)).
     */
    get(certificateId: string, options?: Core.RequestOptions): Core.APIPromise<OriginCACertificate>;
}
export declare class OriginCACertificatesSinglePage extends SinglePage<OriginCACertificate> {
}
export interface OriginCACertificate {
    /**
     * The Certificate Signing Request (CSR). Must be newline-encoded.
     */
    csr: string;
    /**
     * Array of hostnames or wildcard names (e.g., \*.example.com) bound to the
     * certificate.
     */
    hostnames: Array<string>;
    /**
     * Signature type desired on certificate ("origin-rsa" (rsa), "origin-ecc" (ecdsa),
     * or "keyless-certificate" (for Keyless SSL servers).
     */
    request_type: Shared.CertificateRequestType;
    /**
     * The number of days for which the certificate should be valid.
     */
    requested_validity: CertificatePacksAPI.RequestValidity;
    /**
     * Identifier
     */
    id?: string;
    /**
     * The Origin CA certificate. Will be newline-encoded.
     */
    certificate?: string;
    /**
     * When the certificate will expire.
     */
    expires_on?: string;
}
export interface OriginCACertificateDeleteResponse {
    /**
     * Identifier
     */
    id?: string;
    /**
     * When the certificate was revoked.
     */
    revoked_at?: string;
}
export interface OriginCACertificateCreateParams {
    /**
     * The Certificate Signing Request (CSR). Must be newline-encoded.
     */
    csr?: string;
    /**
     * Array of hostnames or wildcard names (e.g., \*.example.com) bound to the
     * certificate.
     */
    hostnames?: Array<string>;
    /**
     * Signature type desired on certificate ("origin-rsa" (rsa), "origin-ecc" (ecdsa),
     * or "keyless-certificate" (for Keyless SSL servers).
     */
    request_type?: Shared.CertificateRequestTypeParam;
    /**
     * The number of days for which the certificate should be valid.
     */
    requested_validity?: CertificatePacksAPI.RequestValidityParam;
}
export interface OriginCACertificateListParams {
    /**
     * Identifier
     */
    zone_id: string;
}
//# sourceMappingURL=origin-ca-certificates.d.ts.map