"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.OriginCACertificatesSinglePage = exports.OriginCACertificates = void 0;
const resource_1 = require("../resource.js");
const pagination_1 = require("../pagination.js");
class OriginCACertificates extends resource_1.APIResource {
    /**
     * Create an Origin CA certificate. You can use an Origin CA Key as your User
     * Service Key or an API token when calling this endpoint ([see above](#requests)).
     */
    create(body, options) {
        return this._client.post('/certificates', { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List all existing Origin CA certificates for a given zone. You can use an Origin
     * CA Key as your User Service Key or an API token when calling this endpoint
     * ([see above](#requests)).
     */
    list(query, options) {
        return this._client.getAPIList('/certificates', OriginCACertificatesSinglePage, { query, ...options });
    }
    /**
     * Revoke an existing Origin CA certificate by its serial number. You can use an
     * Origin CA Key as your User Service Key or an API token when calling this
     * endpoint ([see above](#requests)).
     */
    delete(certificateId, options) {
        return this._client.delete(`/certificates/${certificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get an existing Origin CA certificate by its serial number. You can use an
     * Origin CA Key as your User Service Key or an API token when calling this
     * endpoint ([see above](#requests)).
     */
    get(certificateId, options) {
        return this._client.get(`/certificates/${certificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.OriginCACertificates = OriginCACertificates;
class OriginCACertificatesSinglePage extends pagination_1.SinglePage {
}
exports.OriginCACertificatesSinglePage = OriginCACertificatesSinglePage;
//# sourceMappingURL=origin-ca-certificates.js.map