// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../resource.mjs";
import { SinglePage } from "../pagination.mjs";
export class OriginCACertificates extends APIResource {
    /**
     * Create an Origin CA certificate. You can use an Origin CA Key as your User
     * Service Key or an API token when calling this endpoint ([see above](#requests)).
     */
    create(body, options) {
        return this._client.post('/certificates', { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List all existing Origin CA certificates for a given zone. You can use an Origin
     * CA Key as your User Service Key or an API token when calling this endpoint
     * ([see above](#requests)).
     */
    list(query, options) {
        return this._client.getAPIList('/certificates', OriginCACertificatesSinglePage, { query, ...options });
    }
    /**
     * Revoke an existing Origin CA certificate by its serial number. You can use an
     * Origin CA Key as your User Service Key or an API token when calling this
     * endpoint ([see above](#requests)).
     */
    delete(certificateId, options) {
        return this._client.delete(`/certificates/${certificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get an existing Origin CA certificate by its serial number. You can use an
     * Origin CA Key as your User Service Key or an API token when calling this
     * endpoint ([see above](#requests)).
     */
    get(certificateId, options) {
        return this._client.get(`/certificates/${certificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class OriginCACertificatesSinglePage extends SinglePage {
}
//# sourceMappingURL=origin-ca-certificates.mjs.map