"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.CertificateListResponsesSinglePage = exports.Certificates = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class Certificates extends resource_1.APIResource {
    /**
     * Upload a certificate to be used for client authentication on a hostname. 10
     * hostname certificates per zone are allowed.
     */
    create(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/origin_tls_client_auth/hostnames/certificates`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List Certificates
     */
    list(params, options) {
        const { zone_id } = params;
        return this._client.getAPIList(`/zones/${zone_id}/origin_tls_client_auth/hostnames/certificates`, CertificateListResponsesSinglePage, options);
    }
    /**
     * Delete Hostname Client Certificate
     */
    delete(certificateId, params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/origin_tls_client_auth/hostnames/certificates/${certificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get the certificate by ID to be used for client authentication on a hostname.
     */
    get(certificateId, params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/origin_tls_client_auth/hostnames/certificates/${certificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Certificates = Certificates;
class CertificateListResponsesSinglePage extends pagination_1.SinglePage {
}
exports.CertificateListResponsesSinglePage = CertificateListResponsesSinglePage;
Certificates.CertificateListResponsesSinglePage = CertificateListResponsesSinglePage;
//# sourceMappingURL=certificates.js.map