// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class Certificates extends APIResource {
    /**
     * Upload a certificate to be used for client authentication on a hostname. 10
     * hostname certificates per zone are allowed.
     */
    create(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/origin_tls_client_auth/hostnames/certificates`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List Certificates
     */
    list(params, options) {
        const { zone_id } = params;
        return this._client.getAPIList(`/zones/${zone_id}/origin_tls_client_auth/hostnames/certificates`, CertificateListResponsesSinglePage, options);
    }
    /**
     * Delete Hostname Client Certificate
     */
    delete(certificateId, params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/origin_tls_client_auth/hostnames/certificates/${certificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get the certificate by ID to be used for client authentication on a hostname.
     */
    get(certificateId, params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/origin_tls_client_auth/hostnames/certificates/${certificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class CertificateListResponsesSinglePage extends SinglePage {
}
Certificates.CertificateListResponsesSinglePage = CertificateListResponsesSinglePage;
//# sourceMappingURL=certificates.mjs.map