import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
import * as CertificatesAPI from "./certificates.js";
import { Certificate, CertificateCreateParams, CertificateCreateResponse, CertificateDeleteParams, CertificateDeleteResponse, CertificateGetParams, CertificateGetResponse, CertificateListParams, CertificateListResponse, CertificateListResponsesSinglePage, Certificates } from "./certificates.js";
import { SinglePage } from "../../../pagination.js";
export declare class Hostnames extends APIResource {
    certificates: CertificatesAPI.Certificates;
    /**
     * Associate a hostname to a certificate and enable, disable or invalidate the
     * association. If disabled, client certificate will not be sent to the hostname
     * even if activated at the zone level. 100 maximum associations on a single
     * certificate are allowed. Note: Use a null value for parameter _enabled_ to
     * invalidate the association.
     */
    update(params: HostnameUpdateParams, options?: Core.RequestOptions): Core.PagePromise<HostnameUpdateResponsesSinglePage, HostnameUpdateResponse>;
    /**
     * Get the Hostname Status for Client Authentication
     */
    get(hostname: string, params: HostnameGetParams, options?: Core.RequestOptions): Core.APIPromise<AuthenticatedOriginPull>;
}
export declare class HostnameUpdateResponsesSinglePage extends SinglePage<HostnameUpdateResponse> {
}
export interface AuthenticatedOriginPull {
    /**
     * Identifier
     */
    cert_id?: string;
    /**
     * Status of the certificate or the association.
     */
    cert_status?: 'initializing' | 'pending_deployment' | 'pending_deletion' | 'active' | 'deleted' | 'deployment_timed_out' | 'deletion_timed_out';
    /**
     * The time when the certificate was updated.
     */
    cert_updated_at?: string;
    /**
     * The time when the certificate was uploaded.
     */
    cert_uploaded_on?: string;
    /**
     * The hostname certificate.
     */
    certificate?: string;
    /**
     * The time when the certificate was created.
     */
    created_at?: string;
    /**
     * Indicates whether hostname-level authenticated origin pulls is enabled. A null
     * value voids the association.
     */
    enabled?: boolean | null;
    /**
     * The date when the certificate expires.
     */
    expires_on?: string;
    /**
     * The hostname on the origin for which the client certificate uploaded will be
     * used.
     */
    hostname?: string;
    /**
     * The certificate authority that issued the certificate.
     */
    issuer?: string;
    /**
     * The serial number on the uploaded certificate.
     */
    serial_number?: string;
    /**
     * The type of hash used for the certificate.
     */
    signature?: string;
    /**
     * Status of the certificate or the association.
     */
    status?: 'initializing' | 'pending_deployment' | 'pending_deletion' | 'active' | 'deleted' | 'deployment_timed_out' | 'deletion_timed_out';
    /**
     * The time when the certificate was updated.
     */
    updated_at?: string;
}
export interface HostnameUpdateResponse extends AuthenticatedOriginPull {
    /**
     * Identifier
     */
    id?: string;
    /**
     * Identifier
     */
    cert_id?: string;
    /**
     * The hostname certificate.
     */
    certificate?: string;
    /**
     * Indicates whether hostname-level authenticated origin pulls is enabled. A null
     * value voids the association.
     */
    enabled?: boolean | null;
    /**
     * The hostname on the origin for which the client certificate uploaded will be
     * used.
     */
    hostname?: string;
    /**
     * The hostname certificate's private key.
     */
    private_key?: string;
}
export interface HostnameUpdateParams {
    /**
     * Path param: Identifier
     */
    zone_id: string;
    /**
     * Body param:
     */
    config: Array<HostnameUpdateParams.Config>;
}
export declare namespace HostnameUpdateParams {
    interface Config {
        /**
         * Certificate identifier tag.
         */
        cert_id?: string;
        /**
         * Indicates whether hostname-level authenticated origin pulls is enabled. A null
         * value voids the association.
         */
        enabled?: boolean | null;
        /**
         * The hostname on the origin for which the client certificate uploaded will be
         * used.
         */
        hostname?: string;
    }
}
export interface HostnameGetParams {
    /**
     * Identifier
     */
    zone_id: string;
}
export declare namespace Hostnames {
    export { type AuthenticatedOriginPull as AuthenticatedOriginPull, type HostnameUpdateResponse as HostnameUpdateResponse, HostnameUpdateResponsesSinglePage as HostnameUpdateResponsesSinglePage, type HostnameUpdateParams as HostnameUpdateParams, type HostnameGetParams as HostnameGetParams, };
    export { Certificates as Certificates, type Certificate as Certificate, type CertificateCreateResponse as CertificateCreateResponse, type CertificateListResponse as CertificateListResponse, type CertificateDeleteResponse as CertificateDeleteResponse, type CertificateGetResponse as CertificateGetResponse, CertificateListResponsesSinglePage as CertificateListResponsesSinglePage, type CertificateCreateParams as CertificateCreateParams, type CertificateListParams as CertificateListParams, type CertificateDeleteParams as CertificateDeleteParams, type CertificateGetParams as CertificateGetParams, };
}
//# sourceMappingURL=hostnames.d.ts.map