import { APIResource } from "../../resource.js";
import * as Core from "../../core.js";
import * as SettingsAPI from "./settings.js";
import { SettingGetParams, SettingGetResponse, SettingUpdateParams, SettingUpdateResponse, Settings } from "./settings.js";
import * as HostnamesAPI from "./hostnames/hostnames.js";
import { AuthenticatedOriginPull, HostnameGetParams, HostnameUpdateParams, HostnameUpdateResponse, HostnameUpdateResponsesSinglePage, Hostnames } from "./hostnames/hostnames.js";
import { SinglePage } from "../../pagination.js";
export declare class OriginTLSClientAuth extends APIResource {
    hostnames: HostnamesAPI.Hostnames;
    settings: SettingsAPI.Settings;
    /**
     * Upload your own certificate you want Cloudflare to use for edge-to-origin
     * communication to override the shared certificate. Please note that it is
     * important to keep only one certificate active. Also, make sure to enable
     * zone-level authenticated origin pulls by making a PUT call to settings endpoint
     * to see the uploaded certificate in use.
     */
    create(params: OriginTLSClientAuthCreateParams, options?: Core.RequestOptions): Core.APIPromise<OriginTLSClientAuthCreateResponse>;
    /**
     * List Certificates
     */
    list(params: OriginTLSClientAuthListParams, options?: Core.RequestOptions): Core.PagePromise<OriginTLSClientAuthListResponsesSinglePage, OriginTLSClientAuthListResponse>;
    /**
     * Delete Certificate
     */
    delete(certificateId: string, params: OriginTLSClientAuthDeleteParams, options?: Core.RequestOptions): Core.APIPromise<OriginTLSClientAuthDeleteResponse>;
    /**
     * Get Certificate Details
     */
    get(certificateId: string, params: OriginTLSClientAuthGetParams, options?: Core.RequestOptions): Core.APIPromise<OriginTLSClientAuthGetResponse>;
}
export declare class OriginTLSClientAuthListResponsesSinglePage extends SinglePage<OriginTLSClientAuthListResponse> {
}
export interface ZoneAuthenticatedOriginPull {
    /**
     * Identifier
     */
    id?: string;
    /**
     * The zone's leaf certificate.
     */
    certificate?: string;
    /**
     * When the certificate from the authority expires.
     */
    expires_on?: string;
    /**
     * The certificate authority that issued the certificate.
     */
    issuer?: string;
    /**
     * The type of hash used for the certificate.
     */
    signature?: string;
    /**
     * Status of the certificate activation.
     */
    status?: 'initializing' | 'pending_deployment' | 'pending_deletion' | 'active' | 'deleted' | 'deployment_timed_out' | 'deletion_timed_out';
    /**
     * This is the time the certificate was uploaded.
     */
    uploaded_on?: string;
}
export interface OriginTLSClientAuthCreateResponse extends ZoneAuthenticatedOriginPull {
    /**
     * Identifier
     */
    id?: string;
    /**
     * The zone's leaf certificate.
     */
    certificate?: string;
    /**
     * Indicates whether zone-level authenticated origin pulls is enabled.
     */
    enabled?: boolean;
    /**
     * The zone's private key.
     */
    private_key?: string;
}
export interface OriginTLSClientAuthListResponse extends ZoneAuthenticatedOriginPull {
    /**
     * Identifier
     */
    id?: string;
    /**
     * The zone's leaf certificate.
     */
    certificate?: string;
    /**
     * Indicates whether zone-level authenticated origin pulls is enabled.
     */
    enabled?: boolean;
    /**
     * The zone's private key.
     */
    private_key?: string;
}
export interface OriginTLSClientAuthDeleteResponse extends ZoneAuthenticatedOriginPull {
    /**
     * Identifier
     */
    id?: string;
    /**
     * The zone's leaf certificate.
     */
    certificate?: string;
    /**
     * Indicates whether zone-level authenticated origin pulls is enabled.
     */
    enabled?: boolean;
    /**
     * The zone's private key.
     */
    private_key?: string;
}
export interface OriginTLSClientAuthGetResponse extends ZoneAuthenticatedOriginPull {
    /**
     * Identifier
     */
    id?: string;
    /**
     * The zone's leaf certificate.
     */
    certificate?: string;
    /**
     * Indicates whether zone-level authenticated origin pulls is enabled.
     */
    enabled?: boolean;
    /**
     * The zone's private key.
     */
    private_key?: string;
}
export interface OriginTLSClientAuthCreateParams {
    /**
     * Path param: Identifier
     */
    zone_id: string;
    /**
     * Body param: The zone's leaf certificate.
     */
    certificate: string;
    /**
     * Body param: The zone's private key.
     */
    private_key: string;
}
export interface OriginTLSClientAuthListParams {
    /**
     * Identifier
     */
    zone_id: string;
}
export interface OriginTLSClientAuthDeleteParams {
    /**
     * Identifier
     */
    zone_id: string;
}
export interface OriginTLSClientAuthGetParams {
    /**
     * Identifier
     */
    zone_id: string;
}
export declare namespace OriginTLSClientAuth {
    export { Hostnames as Hostnames, type AuthenticatedOriginPull as AuthenticatedOriginPull, type HostnameUpdateResponse as HostnameUpdateResponse, HostnameUpdateResponsesSinglePage as HostnameUpdateResponsesSinglePage, type HostnameUpdateParams as HostnameUpdateParams, type HostnameGetParams as HostnameGetParams, };
    export { Settings as Settings, type SettingUpdateResponse as SettingUpdateResponse, type SettingGetResponse as SettingGetResponse, type SettingUpdateParams as SettingUpdateParams, type SettingGetParams as SettingGetParams, };
}
//# sourceMappingURL=origin-tls-client-auth.d.ts.map