"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OriginTLSClientAuthListResponsesSinglePage = exports.OriginTLSClientAuth = void 0;
const resource_1 = require("../../resource.js");
const SettingsAPI = __importStar(require("./settings.js"));
const settings_1 = require("./settings.js");
const HostnamesAPI = __importStar(require("./hostnames/hostnames.js"));
const hostnames_1 = require("./hostnames/hostnames.js");
const pagination_1 = require("../../pagination.js");
class OriginTLSClientAuth extends resource_1.APIResource {
    constructor() {
        super(...arguments);
        this.hostnames = new HostnamesAPI.Hostnames(this._client);
        this.settings = new SettingsAPI.Settings(this._client);
    }
    /**
     * Upload your own certificate you want Cloudflare to use for edge-to-origin
     * communication to override the shared certificate. Please note that it is
     * important to keep only one certificate active. Also, make sure to enable
     * zone-level authenticated origin pulls by making a PUT call to settings endpoint
     * to see the uploaded certificate in use.
     */
    create(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/origin_tls_client_auth`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List Certificates
     */
    list(params, options) {
        const { zone_id } = params;
        return this._client.getAPIList(`/zones/${zone_id}/origin_tls_client_auth`, OriginTLSClientAuthListResponsesSinglePage, options);
    }
    /**
     * Delete Certificate
     */
    delete(certificateId, params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/origin_tls_client_auth/${certificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get Certificate Details
     */
    get(certificateId, params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/origin_tls_client_auth/${certificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.OriginTLSClientAuth = OriginTLSClientAuth;
class OriginTLSClientAuthListResponsesSinglePage extends pagination_1.SinglePage {
}
exports.OriginTLSClientAuthListResponsesSinglePage = OriginTLSClientAuthListResponsesSinglePage;
OriginTLSClientAuth.Hostnames = hostnames_1.Hostnames;
OriginTLSClientAuth.HostnameUpdateResponsesSinglePage = hostnames_1.HostnameUpdateResponsesSinglePage;
OriginTLSClientAuth.Settings = settings_1.Settings;
//# sourceMappingURL=origin-tls-client-auth.js.map