// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import * as SettingsAPI from "./settings.mjs";
import { Settings, } from "./settings.mjs";
import * as HostnamesAPI from "./hostnames/hostnames.mjs";
import { HostnameUpdateResponsesSinglePage, Hostnames, } from "./hostnames/hostnames.mjs";
import { SinglePage } from "../../pagination.mjs";
export class OriginTLSClientAuth extends APIResource {
    constructor() {
        super(...arguments);
        this.hostnames = new HostnamesAPI.Hostnames(this._client);
        this.settings = new SettingsAPI.Settings(this._client);
    }
    /**
     * Upload your own certificate you want Cloudflare to use for edge-to-origin
     * communication to override the shared certificate. Please note that it is
     * important to keep only one certificate active. Also, make sure to enable
     * zone-level authenticated origin pulls by making a PUT call to settings endpoint
     * to see the uploaded certificate in use.
     */
    create(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/origin_tls_client_auth`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List Certificates
     */
    list(params, options) {
        const { zone_id } = params;
        return this._client.getAPIList(`/zones/${zone_id}/origin_tls_client_auth`, OriginTLSClientAuthListResponsesSinglePage, options);
    }
    /**
     * Delete Certificate
     */
    delete(certificateId, params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/origin_tls_client_auth/${certificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get Certificate Details
     */
    get(certificateId, params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/origin_tls_client_auth/${certificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class OriginTLSClientAuthListResponsesSinglePage extends SinglePage {
}
OriginTLSClientAuth.Hostnames = Hostnames;
OriginTLSClientAuth.HostnameUpdateResponsesSinglePage = HostnameUpdateResponsesSinglePage;
OriginTLSClientAuth.Settings = Settings;
//# sourceMappingURL=origin-tls-client-auth.mjs.map