import { APIResource } from "../../resource.js";
import * as Core from "../../core.js";
export declare class Settings extends APIResource {
    /**
     * Enable or disable zone-level authenticated origin pulls. 'enabled' should be set
     * true either before/after the certificate is uploaded to see the certificate in
     * use.
     */
    update(params: SettingUpdateParams, options?: Core.RequestOptions): Core.APIPromise<SettingUpdateResponse>;
    /**
     * Get whether zone-level authenticated origin pulls is enabled or not. It is false
     * by default.
     */
    get(params: SettingGetParams, options?: Core.RequestOptions): Core.APIPromise<SettingGetResponse>;
}
export interface SettingUpdateResponse {
    /**
     * Indicates whether zone-level authenticated origin pulls is enabled.
     */
    enabled?: boolean;
}
export interface SettingGetResponse {
    /**
     * Indicates whether zone-level authenticated origin pulls is enabled.
     */
    enabled?: boolean;
}
export interface SettingUpdateParams {
    /**
     * Path param: Identifier
     */
    zone_id: string;
    /**
     * Body param: Indicates whether zone-level authenticated origin pulls is enabled.
     */
    enabled: boolean;
}
export interface SettingGetParams {
    /**
     * Identifier
     */
    zone_id: string;
}
export declare namespace Settings {
    export { type SettingUpdateResponse as SettingUpdateResponse, type SettingGetResponse as SettingGetResponse, type SettingUpdateParams as SettingUpdateParams, type SettingGetParams as SettingGetParams, };
}
//# sourceMappingURL=settings.d.ts.map