"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.PageRules = void 0;
const resource_1 = require("../resource.js");
class PageRules extends resource_1.APIResource {
    /**
     * Creates a new Page Rule.
     */
    create(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/pagerules`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Replaces the configuration of an existing Page Rule. The configuration of the
     * updated Page Rule will exactly match the data passed in the API request.
     */
    update(pageruleId, params, options) {
        const { zone_id, ...body } = params;
        return this._client.put(`/zones/${zone_id}/pagerules/${pageruleId}`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches Page Rules in a zone.
     */
    list(params, options) {
        const { zone_id, ...query } = params;
        return this._client.get(`/zones/${zone_id}/pagerules`, { query, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Deletes an existing Page Rule.
     */
    delete(pageruleId, params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/pagerules/${pageruleId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates one or more fields of an existing Page Rule.
     */
    edit(pageruleId, params, options) {
        const { zone_id, ...body } = params;
        return this._client.patch(`/zones/${zone_id}/pagerules/${pageruleId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches the details of a Page Rule.
     */
    get(pageruleId, params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/pagerules/${pageruleId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.PageRules = PageRules;
//# sourceMappingURL=page-rules.js.map