// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import { SinglePage } from "../../pagination.mjs";
export class Cookies extends APIResource {
    /**
     * Lists all cookies collected by Page Shield.
     */
    list(params, options) {
        const { zone_id, ...query } = params;
        return this._client.getAPIList(`/zones/${zone_id}/page_shield/cookies`, CookieListResponsesSinglePage, {
            query,
            ...options,
        });
    }
    /**
     * Fetches a cookie collected by Page Shield by cookie ID.
     */
    get(cookieId, params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/page_shield/cookies/${cookieId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class CookieListResponsesSinglePage extends SinglePage {
}
Cookies.CookieListResponsesSinglePage = CookieListResponsesSinglePage;
//# sourceMappingURL=cookies.mjs.map