import { APIResource } from "../../resource.js";
import * as Core from "../../core.js";
import { SinglePage } from "../../pagination.js";
export declare class Policies extends APIResource {
    /**
     * Create a Page Shield policy.
     */
    create(params: PolicyCreateParams, options?: Core.RequestOptions): Core.APIPromise<PolicyCreateResponse | null>;
    /**
     * Update a Page Shield policy by ID.
     */
    update(policyId: string, params: PolicyUpdateParams, options?: Core.RequestOptions): Core.APIPromise<PolicyUpdateResponse | null>;
    /**
     * Lists all Page Shield policies.
     */
    list(params: PolicyListParams, options?: Core.RequestOptions): Core.PagePromise<PolicyListResponsesSinglePage, PolicyListResponse>;
    /**
     * Delete a Page Shield policy by ID.
     */
    delete(policyId: string, params: PolicyDeleteParams, options?: Core.RequestOptions): Core.APIPromise<void>;
    /**
     * Fetches a Page Shield policy by ID.
     */
    get(policyId: string, params: PolicyGetParams, options?: Core.RequestOptions): Core.APIPromise<PolicyGetResponse | null>;
}
export declare class PolicyListResponsesSinglePage extends SinglePage<PolicyListResponse> {
}
export interface Policy {
    /**
     * The action to take if the expression matches
     */
    action: 'allow' | 'log';
    /**
     * A description for the policy
     */
    description: string;
    /**
     * Whether the policy is enabled
     */
    enabled: boolean;
    /**
     * The expression which must match for the policy to be applied, using the
     * Cloudflare Firewall rule expression syntax
     */
    expression: string;
    /**
     * The policy which will be applied
     */
    value: string;
}
export interface PolicyCreateResponse {
    /**
     * Identifier
     */
    id: string;
    /**
     * The action to take if the expression matches
     */
    action: 'allow' | 'log';
    /**
     * A description for the policy
     */
    description: string;
    /**
     * Whether the policy is enabled
     */
    enabled: boolean;
    /**
     * The expression which must match for the policy to be applied, using the
     * Cloudflare Firewall rule expression syntax
     */
    expression: string;
    /**
     * The policy which will be applied
     */
    value: string;
}
export interface PolicyUpdateResponse {
    /**
     * Identifier
     */
    id: string;
    /**
     * The action to take if the expression matches
     */
    action: 'allow' | 'log';
    /**
     * A description for the policy
     */
    description: string;
    /**
     * Whether the policy is enabled
     */
    enabled: boolean;
    /**
     * The expression which must match for the policy to be applied, using the
     * Cloudflare Firewall rule expression syntax
     */
    expression: string;
    /**
     * The policy which will be applied
     */
    value: string;
}
export interface PolicyListResponse {
    /**
     * Identifier
     */
    id: string;
    /**
     * The action to take if the expression matches
     */
    action: 'allow' | 'log';
    /**
     * A description for the policy
     */
    description: string;
    /**
     * Whether the policy is enabled
     */
    enabled: boolean;
    /**
     * The expression which must match for the policy to be applied, using the
     * Cloudflare Firewall rule expression syntax
     */
    expression: string;
    /**
     * The policy which will be applied
     */
    value: string;
}
export interface PolicyGetResponse {
    /**
     * Identifier
     */
    id: string;
    /**
     * The action to take if the expression matches
     */
    action: 'allow' | 'log';
    /**
     * A description for the policy
     */
    description: string;
    /**
     * Whether the policy is enabled
     */
    enabled: boolean;
    /**
     * The expression which must match for the policy to be applied, using the
     * Cloudflare Firewall rule expression syntax
     */
    expression: string;
    /**
     * The policy which will be applied
     */
    value: string;
}
export interface PolicyCreateParams {
    /**
     * Path param: Identifier
     */
    zone_id: string;
    /**
     * Body param: The action to take if the expression matches
     */
    action: 'allow' | 'log';
    /**
     * Body param: A description for the policy
     */
    description: string;
    /**
     * Body param: Whether the policy is enabled
     */
    enabled: boolean;
    /**
     * Body param: The expression which must match for the policy to be applied, using
     * the Cloudflare Firewall rule expression syntax
     */
    expression: string;
    /**
     * Body param: The policy which will be applied
     */
    value: string;
}
export interface PolicyUpdateParams {
    /**
     * Path param: Identifier
     */
    zone_id: string;
    /**
     * Body param: The action to take if the expression matches
     */
    action?: 'allow' | 'log';
    /**
     * Body param: A description for the policy
     */
    description?: string;
    /**
     * Body param: Whether the policy is enabled
     */
    enabled?: boolean;
    /**
     * Body param: The expression which must match for the policy to be applied, using
     * the Cloudflare Firewall rule expression syntax
     */
    expression?: string;
    /**
     * Body param: The policy which will be applied
     */
    value?: string;
}
export interface PolicyListParams {
    /**
     * Identifier
     */
    zone_id: string;
}
export interface PolicyDeleteParams {
    /**
     * Identifier
     */
    zone_id: string;
}
export interface PolicyGetParams {
    /**
     * Identifier
     */
    zone_id: string;
}
export declare namespace Policies {
    export { type Policy as Policy, type PolicyCreateResponse as PolicyCreateResponse, type PolicyUpdateResponse as PolicyUpdateResponse, type PolicyListResponse as PolicyListResponse, type PolicyGetResponse as PolicyGetResponse, PolicyListResponsesSinglePage as PolicyListResponsesSinglePage, type PolicyCreateParams as PolicyCreateParams, type PolicyUpdateParams as PolicyUpdateParams, type PolicyListParams as PolicyListParams, type PolicyDeleteParams as PolicyDeleteParams, type PolicyGetParams as PolicyGetParams, };
}
//# sourceMappingURL=policies.d.ts.map