// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import { SinglePage } from "../../pagination.mjs";
export class Policies extends APIResource {
    /**
     * Create a Page Shield policy.
     */
    create(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/page_shield/policies`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update a Page Shield policy by ID.
     */
    update(policyId, params, options) {
        const { zone_id, ...body } = params;
        return this._client.put(`/zones/${zone_id}/page_shield/policies/${policyId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists all Page Shield policies.
     */
    list(params, options) {
        const { zone_id } = params;
        return this._client.getAPIList(`/zones/${zone_id}/page_shield/policies`, PolicyListResponsesSinglePage, options);
    }
    /**
     * Delete a Page Shield policy by ID.
     */
    delete(policyId, params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/page_shield/policies/${policyId}`, {
            ...options,
            headers: { Accept: '*/*', ...options?.headers },
        });
    }
    /**
     * Fetches a Page Shield policy by ID.
     */
    get(policyId, params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/page_shield/policies/${policyId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class PolicyListResponsesSinglePage extends SinglePage {
}
Policies.PolicyListResponsesSinglePage = PolicyListResponsesSinglePage;
//# sourceMappingURL=policies.mjs.map