"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScriptsSinglePage = exports.Scripts = void 0;
const resource_1 = require("../../resource.js");
const pagination_1 = require("../../pagination.js");
class Scripts extends resource_1.APIResource {
    /**
     * Lists all scripts detected by Page Shield.
     */
    list(params, options) {
        const { zone_id, ...query } = params;
        return this._client.getAPIList(`/zones/${zone_id}/page_shield/scripts`, ScriptsSinglePage, {
            query,
            ...options,
        });
    }
    /**
     * Fetches a script detected by Page Shield by script ID.
     */
    get(scriptId, params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/page_shield/scripts/${scriptId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Scripts = Scripts;
class ScriptsSinglePage extends pagination_1.SinglePage {
}
exports.ScriptsSinglePage = ScriptsSinglePage;
Scripts.ScriptsSinglePage = ScriptsSinglePage;
//# sourceMappingURL=scripts.js.map