// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import { SinglePage } from "../../pagination.mjs";
export class Scripts extends APIResource {
    /**
     * Lists all scripts detected by Page Shield.
     */
    list(params, options) {
        const { zone_id, ...query } = params;
        return this._client.getAPIList(`/zones/${zone_id}/page_shield/scripts`, ScriptsSinglePage, {
            query,
            ...options,
        });
    }
    /**
     * Fetches a script detected by Page Shield by script ID.
     */
    get(scriptId, params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/page_shield/scripts/${scriptId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class ScriptsSinglePage extends SinglePage {
}
Scripts.ScriptsSinglePage = ScriptsSinglePage;
//# sourceMappingURL=scripts.mjs.map