import { APIResource } from "../../../../resource.js";
import * as Core from "../../../../core.js";
import * as ProjectsAPI from "../projects.js";
import { DeploymentsSinglePage } from "../projects.js";
import * as HistoryAPI from "./history/history.js";
import { History } from "./history/history.js";
export declare class Deployments extends APIResource {
    history: HistoryAPI.History;
    /**
     * Start a new deployment from production. The repository and account must have
     * already been authorized on the Cloudflare Pages dashboard.
     */
    create(projectName: string, params: DeploymentCreateParams, options?: Core.RequestOptions): Core.APIPromise<ProjectsAPI.Deployment>;
    /**
     * Fetch a list of project deployments.
     */
    list(projectName: string, params: DeploymentListParams, options?: Core.RequestOptions): Core.PagePromise<DeploymentsSinglePage, ProjectsAPI.Deployment>;
    /**
     * Delete a deployment.
     */
    delete(projectName: string, deploymentId: string, params: DeploymentDeleteParams, options?: Core.RequestOptions): Core.APIPromise<DeploymentDeleteResponse | null>;
    /**
     * Fetch information about a deployment.
     */
    get(projectName: string, deploymentId: string, params: DeploymentGetParams, options?: Core.RequestOptions): Core.APIPromise<ProjectsAPI.Deployment>;
    /**
     * Retry a previous deployment.
     */
    retry(projectName: string, deploymentId: string, params: DeploymentRetryParams, options?: Core.RequestOptions): Core.APIPromise<ProjectsAPI.Deployment>;
    /**
     * Rollback the production deployment to a previous deployment. You can only
     * rollback to succesful builds on production.
     */
    rollback(projectName: string, deploymentId: string, params: DeploymentRollbackParams, options?: Core.RequestOptions): Core.APIPromise<ProjectsAPI.Deployment>;
}
export type DeploymentDeleteResponse = unknown;
export interface DeploymentCreateParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Body param: The branch to build the new deployment from. The `HEAD` of the
     * branch will be used. If omitted, the production branch will be used by default.
     */
    branch?: string;
}
export interface DeploymentListParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Query param: What type of deployments to fetch.
     */
    env?: 'production' | 'preview';
}
export interface DeploymentDeleteParams {
    /**
     * Identifier
     */
    account_id: string;
}
export interface DeploymentGetParams {
    /**
     * Identifier
     */
    account_id: string;
}
export interface DeploymentRetryParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Body param:
     */
    body: unknown;
}
export interface DeploymentRollbackParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Body param:
     */
    body: unknown;
}
export declare namespace Deployments {
    export { type DeploymentDeleteResponse as DeploymentDeleteResponse, type DeploymentCreateParams as DeploymentCreateParams, type DeploymentListParams as DeploymentListParams, type DeploymentDeleteParams as DeploymentDeleteParams, type DeploymentGetParams as DeploymentGetParams, type DeploymentRetryParams as DeploymentRetryParams, type DeploymentRollbackParams as DeploymentRollbackParams, };
    export { History as History };
}
export { DeploymentsSinglePage };
//# sourceMappingURL=deployments.d.ts.map