// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../../resource.mjs";
import * as Core from "../../../../core.mjs";
import { DeploymentsSinglePage } from "../projects.mjs";
import * as HistoryAPI from "./history/history.mjs";
import { History } from "./history/history.mjs";
export class Deployments extends APIResource {
    constructor() {
        super(...arguments);
        this.history = new HistoryAPI.History(this._client);
    }
    /**
     * Start a new deployment from production. The repository and account must have
     * already been authorized on the Cloudflare Pages dashboard.
     */
    create(projectName, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/pages/projects/${projectName}/deployments`, Core.multipartFormRequestOptions({ body, ...options }))._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetch a list of project deployments.
     */
    list(projectName, params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/pages/projects/${projectName}/deployments`, DeploymentsSinglePage, { query, ...options });
    }
    /**
     * Delete a deployment.
     */
    delete(projectName, deploymentId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/pages/projects/${projectName}/deployments/${deploymentId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetch information about a deployment.
     */
    get(projectName, deploymentId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/pages/projects/${projectName}/deployments/${deploymentId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Retry a previous deployment.
     */
    retry(projectName, deploymentId, params, options) {
        const { account_id, body } = params;
        return this._client.post(`/accounts/${account_id}/pages/projects/${projectName}/deployments/${deploymentId}/retry`, { body: body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Rollback the production deployment to a previous deployment. You can only
     * rollback to succesful builds on production.
     */
    rollback(projectName, deploymentId, params, options) {
        const { account_id, body } = params;
        return this._client.post(`/accounts/${account_id}/pages/projects/${projectName}/deployments/${deploymentId}/rollback`, { body: body, ...options })._thenUnwrap((obj) => obj.result);
    }
}
Deployments.History = History;
export { DeploymentsSinglePage };
//# sourceMappingURL=deployments.mjs.map