"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.DomainListResponsesSinglePage = exports.Domains = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class Domains extends resource_1.APIResource {
    /**
     * Add a new domain for the Pages project.
     */
    create(projectName, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/pages/projects/${projectName}/domains`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetch a list of all domains associated with a Pages project.
     */
    list(projectName, params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/pages/projects/${projectName}/domains`, DomainListResponsesSinglePage, options);
    }
    /**
     * Delete a Pages project's domain.
     */
    delete(projectName, domainName, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/pages/projects/${projectName}/domains/${domainName}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Retry the validation status of a single domain.
     */
    edit(projectName, domainName, params, options) {
        const { account_id, body } = params;
        return this._client.patch(`/accounts/${account_id}/pages/projects/${projectName}/domains/${domainName}`, {
            body: body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetch a single domain.
     */
    get(projectName, domainName, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/pages/projects/${projectName}/domains/${domainName}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Domains = Domains;
class DomainListResponsesSinglePage extends pagination_1.SinglePage {
}
exports.DomainListResponsesSinglePage = DomainListResponsesSinglePage;
Domains.DomainListResponsesSinglePage = DomainListResponsesSinglePage;
//# sourceMappingURL=domains.js.map