// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import * as DomainsAPI from "./domains.mjs";
import { DomainListResponsesSinglePage, Domains, } from "./domains.mjs";
import * as DeploymentsAPI from "./deployments/deployments.mjs";
import { Deployments, } from "./deployments/deployments.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class Projects extends APIResource {
    constructor() {
        super(...arguments);
        this.deployments = new DeploymentsAPI.Deployments(this._client);
        this.domains = new DomainsAPI.Domains(this._client);
    }
    /**
     * Create a new project.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/pages/projects`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetch a list of all user projects.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/pages/projects`, DeploymentsSinglePage, options);
    }
    /**
     * Delete a project by name.
     */
    delete(projectName, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/pages/projects/${projectName}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Set new attributes for an existing project. Modify environment variables. To
     * delete an environment variable, set the key to null.
     */
    edit(projectName, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/pages/projects/${projectName}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetch a project by name.
     */
    get(projectName, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/pages/projects/${projectName}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Purge all cached build artifacts for a Pages project
     */
    purgeBuildCache(projectName, params, options) {
        const { account_id } = params;
        return this._client.post(`/accounts/${account_id}/pages/projects/${projectName}/purge_build_cache`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class DeploymentsSinglePage extends SinglePage {
}
Projects.DeploymentsSinglePage = DeploymentsSinglePage;
Projects.Deployments = Deployments;
Projects.Domains = Domains;
Projects.DomainListResponsesSinglePage = DomainListResponsesSinglePage;
//# sourceMappingURL=projects.mjs.map