"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessagePullResponsesSinglePage = exports.Messages = void 0;
const resource_1 = require("../../resource.js");
const pagination_1 = require("../../pagination.js");
class Messages extends resource_1.APIResource {
    /**
     * Acknowledge + Retry messages from a Queue
     */
    ack(queueId, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/queues/${queueId}/messages/ack`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Pull a batch of messages from a Queue
     */
    pull(queueId, params, options) {
        const { account_id, ...body } = params;
        return this._client.getAPIList(`/accounts/${account_id}/queues/${queueId}/messages/pull`, MessagePullResponsesSinglePage, { body, method: 'post', ...options });
    }
}
exports.Messages = Messages;
class MessagePullResponsesSinglePage extends pagination_1.SinglePage {
}
exports.MessagePullResponsesSinglePage = MessagePullResponsesSinglePage;
Messages.MessagePullResponsesSinglePage = MessagePullResponsesSinglePage;
//# sourceMappingURL=messages.js.map