// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import { SinglePage } from "../../pagination.mjs";
export class Messages extends APIResource {
    /**
     * Acknowledge + Retry messages from a Queue
     */
    ack(queueId, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/queues/${queueId}/messages/ack`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Pull a batch of messages from a Queue
     */
    pull(queueId, params, options) {
        const { account_id, ...body } = params;
        return this._client.getAPIList(`/accounts/${account_id}/queues/${queueId}/messages/pull`, MessagePullResponsesSinglePage, { body, method: 'post', ...options });
    }
}
export class MessagePullResponsesSinglePage extends SinglePage {
}
Messages.MessagePullResponsesSinglePage = MessagePullResponsesSinglePage;
//# sourceMappingURL=messages.mjs.map