import { APIResource } from "../../resource.js";
import * as Core from "../../core.js";
import * as Shared from "../shared.js";
import * as ConsumersAPI from "./consumers.js";
import { Consumer, ConsumerCreateParams, ConsumerDeleteParams, ConsumerDeleteResponse, ConsumerGetParams, ConsumerUpdateParams, Consumers, ConsumersSinglePage } from "./consumers.js";
import * as MessagesAPI from "./messages.js";
import { MessageAckParams, MessageAckResponse, MessagePullParams, MessagePullResponse, MessagePullResponsesSinglePage, Messages } from "./messages.js";
import { SinglePage } from "../../pagination.js";
export declare class Queues extends APIResource {
    consumers: ConsumersAPI.Consumers;
    messages: MessagesAPI.Messages;
    /**
     * Create a new queue
     */
    create(params: QueueCreateParams, options?: Core.RequestOptions): Core.APIPromise<Queue>;
    /**
     * Updates a Queue. Note that this endpoint does not support partial updates. If
     * successful, the Queue's configuration is overwritten with the supplied
     * configuration.
     */
    update(queueId: string, params: QueueUpdateParams, options?: Core.RequestOptions): Core.APIPromise<Queue>;
    /**
     * Returns the queues owned by an account.
     */
    list(params: QueueListParams, options?: Core.RequestOptions): Core.PagePromise<QueuesSinglePage, Queue>;
    /**
     * Deletes a queue
     */
    delete(queueId: string, params: QueueDeleteParams, options?: Core.RequestOptions): Core.APIPromise<QueueDeleteResponse>;
    /**
     * Get details about a specific queue.
     */
    get(queueId: string, params: QueueGetParams, options?: Core.RequestOptions): Core.APIPromise<Queue>;
}
export declare class QueuesSinglePage extends SinglePage<Queue> {
}
export interface Queue {
    consumers?: Array<ConsumersAPI.Consumer>;
    consumers_total_count?: number;
    created_on?: string;
    modified_on?: string;
    producers?: Array<Queue.MqWorkerProducer | Queue.MqR2Producer>;
    producers_total_count?: number;
    queue_id?: string;
    queue_name?: string;
    settings?: Queue.Settings;
}
export declare namespace Queue {
    interface MqWorkerProducer {
        script?: string;
        type?: 'worker';
    }
    interface MqR2Producer {
        bucket_name?: string;
        type?: 'r2_bucket';
    }
    interface Settings {
        /**
         * Number of seconds to delay delivery of all messages to consumers.
         */
        delivery_delay?: number;
        /**
         * Number of seconds after which an unconsumed message will be delayed.
         */
        message_retention_period?: number;
    }
}
export interface QueueDeleteResponse {
    errors?: Array<Shared.ResponseInfo>;
    messages?: Array<string>;
    /**
     * Indicates if the API call was successful or not.
     */
    success?: true;
}
export interface QueueCreateParams {
    /**
     * Path param: A Resource identifier.
     */
    account_id: string;
    /**
     * Body param:
     */
    queue_name: string;
}
export interface QueueUpdateParams {
    /**
     * Path param: A Resource identifier.
     */
    account_id: string;
    /**
     * Body param:
     */
    queue_name?: string;
    /**
     * Body param:
     */
    settings?: QueueUpdateParams.Settings;
}
export declare namespace QueueUpdateParams {
    interface Settings {
        /**
         * Number of seconds to delay delivery of all messages to consumers.
         */
        delivery_delay?: number;
        /**
         * Number of seconds after which an unconsumed message will be delayed.
         */
        message_retention_period?: number;
    }
}
export interface QueueListParams {
    /**
     * A Resource identifier.
     */
    account_id: string;
}
export interface QueueDeleteParams {
    /**
     * A Resource identifier.
     */
    account_id: string;
}
export interface QueueGetParams {
    /**
     * A Resource identifier.
     */
    account_id: string;
}
export declare namespace Queues {
    export { Consumers as Consumers, type Consumer as Consumer, type ConsumerDeleteResponse as ConsumerDeleteResponse, ConsumersSinglePage as ConsumersSinglePage, type ConsumerCreateParams as ConsumerCreateParams, type ConsumerUpdateParams as ConsumerUpdateParams, type ConsumerDeleteParams as ConsumerDeleteParams, type ConsumerGetParams as ConsumerGetParams, };
    export { Messages as Messages, type MessageAckResponse as MessageAckResponse, type MessagePullResponse as MessagePullResponse, MessagePullResponsesSinglePage as MessagePullResponsesSinglePage, type MessageAckParams as MessageAckParams, type MessagePullParams as MessagePullParams, };
}
//# sourceMappingURL=queues.d.ts.map