"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.QueuesSinglePage = exports.Queues = void 0;
const resource_1 = require("../../resource.js");
const ConsumersAPI = __importStar(require("./consumers.js"));
const consumers_1 = require("./consumers.js");
const MessagesAPI = __importStar(require("./messages.js"));
const messages_1 = require("./messages.js");
const pagination_1 = require("../../pagination.js");
class Queues extends resource_1.APIResource {
    constructor() {
        super(...arguments);
        this.consumers = new ConsumersAPI.Consumers(this._client);
        this.messages = new MessagesAPI.Messages(this._client);
    }
    /**
     * Create a new queue
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/queues`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates a Queue. Note that this endpoint does not support partial updates. If
     * successful, the Queue's configuration is overwritten with the supplied
     * configuration.
     */
    update(queueId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/queues/${queueId}`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Returns the queues owned by an account.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/queues`, QueuesSinglePage, options);
    }
    /**
     * Deletes a queue
     */
    delete(queueId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/queues/${queueId}`, options);
    }
    /**
     * Get details about a specific queue.
     */
    get(queueId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/queues/${queueId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Queues = Queues;
class QueuesSinglePage extends pagination_1.SinglePage {
}
exports.QueuesSinglePage = QueuesSinglePage;
Queues.Consumers = consumers_1.Consumers;
Queues.ConsumersSinglePage = consumers_1.ConsumersSinglePage;
Queues.Messages = messages_1.Messages;
Queues.MessagePullResponsesSinglePage = messages_1.MessagePullResponsesSinglePage;
//# sourceMappingURL=queues.js.map