// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import * as ConsumersAPI from "./consumers.mjs";
import { Consumers, ConsumersSinglePage, } from "./consumers.mjs";
import * as MessagesAPI from "./messages.mjs";
import { MessagePullResponsesSinglePage, Messages, } from "./messages.mjs";
import { SinglePage } from "../../pagination.mjs";
export class Queues extends APIResource {
    constructor() {
        super(...arguments);
        this.consumers = new ConsumersAPI.Consumers(this._client);
        this.messages = new MessagesAPI.Messages(this._client);
    }
    /**
     * Create a new queue
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/queues`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates a Queue. Note that this endpoint does not support partial updates. If
     * successful, the Queue's configuration is overwritten with the supplied
     * configuration.
     */
    update(queueId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/queues/${queueId}`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Returns the queues owned by an account.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/queues`, QueuesSinglePage, options);
    }
    /**
     * Deletes a queue
     */
    delete(queueId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/queues/${queueId}`, options);
    }
    /**
     * Get details about a specific queue.
     */
    get(queueId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/queues/${queueId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class QueuesSinglePage extends SinglePage {
}
Queues.Consumers = Consumers;
Queues.ConsumersSinglePage = ConsumersSinglePage;
Queues.Messages = Messages;
Queues.MessagePullResponsesSinglePage = MessagePullResponsesSinglePage;
//# sourceMappingURL=queues.mjs.map