import { APIResource } from "../../../../resource.js";
import * as Core from "../../../../core.js";
export declare class Summary extends APIResource {
    /**
     * Retrieves the distribution of traffic by AI user agent.
     */
    userAgent(query?: SummaryUserAgentParams, options?: Core.RequestOptions): Core.APIPromise<SummaryUserAgentResponse>;
    userAgent(options?: Core.RequestOptions): Core.APIPromise<SummaryUserAgentResponse>;
}
export interface SummaryUserAgentResponse {
    meta: SummaryUserAgentResponse.Meta;
    summary_0: Record<string, string>;
}
export declare namespace SummaryUserAgentResponse {
    interface Meta {
        dateRange: Array<Meta.DateRange>;
        lastUpdated: string;
        normalization: string;
        confidenceInfo?: Meta.ConfidenceInfo;
    }
    namespace Meta {
        interface DateRange {
            /**
             * Adjusted end of date range.
             */
            endTime: string;
            /**
             * Adjusted start of date range.
             */
            startTime: string;
        }
        interface ConfidenceInfo {
            annotations?: Array<ConfidenceInfo.Annotation>;
            level?: number;
        }
        namespace ConfidenceInfo {
            interface Annotation {
                dataSource: string;
                description: string;
                eventType: string;
                isInstantaneous: boolean;
                endTime?: string;
                linkedUrl?: string;
                startTime?: string;
            }
        }
    }
}
export interface SummaryUserAgentParams {
    /**
     * Comma-separated list of Autonomous System Numbers (ASNs). Prefix with `-` to
     * exclude ASNs from results. For example, `-174, 3356` excludes results from
     * AS174, but includes results from AS3356.
     */
    asn?: Array<string>;
    /**
     * Comma-separated list of continents (alpha-2 continent codes). Prefix with `-` to
     * exclude continents from results. For example, `-EU,NA` excludes results from EU,
     * but includes results from NA.
     */
    continent?: Array<string>;
    /**
     * End of the date range (inclusive).
     */
    dateEnd?: Array<string>;
    /**
     * Filters results by the specified date range. For example, use `7d` and
     * `7dcontrol` to compare this week with the previous week. Use this parameter or
     * set specific start and end dates (`dateStart` and `dateEnd` parameters).
     */
    dateRange?: Array<string>;
    /**
     * Start of the date range.
     */
    dateStart?: Array<string>;
    /**
     * Format in which results will be returned.
     */
    format?: 'JSON' | 'CSV';
    /**
     * Limits the number of objects per group to the top items within the specified
     * time range. If there are more items than the limit, the response will include
     * the count of items, with any remaining items grouped together under an "other"
     * category.
     */
    limitPerGroup?: number;
    /**
     * Comma-separated list of locations (alpha-2 codes). Prefix with `-` to exclude
     * locations from results. For example, `-US,PT` excludes results from the US, but
     * includes results from PT.
     */
    location?: Array<string>;
    /**
     * Array of names used to label the series in the response.
     */
    name?: Array<string>;
}
export declare namespace Summary {
    export { type SummaryUserAgentResponse as SummaryUserAgentResponse, type SummaryUserAgentParams as SummaryUserAgentParams, };
}
//# sourceMappingURL=summary.d.ts.map